<?php 
	// Includes
		include '../inc/config.php';
		include '../inc/functions.php';
	
	// IP opvragen
		$ip = getIP();
	
	// Event log wegschrijven
		write_log("Verbinding vanuit ip $ip","event");
	
	// Mag dit ip verbinding maken?
		if(!in_array($ip, $allowed_ips)){
			write_log("Fout: verbinding vanuit dit IP-adres ($ip) niet toegestaan!","error");
			exit;
		}
		
	// Controle op session hash
		if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
			write_log("Fout: geen of te korte/lange session_hash opgegeven!","error");
			exit;
		}
		
	// Controle op lerarenid
		if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
			write_log("Fout: geen lerarenid opgegeven!","error");
			exit;
		}
	
	// Controle op datumvan en datumtot ingevuld
		if(!isset($_GET['datumvan']) || !isset($_GET['datumtot'])){
			write_log("Fout: geen begin of einddatum opgegeven!","error");
			exit;
		}	
		
	// Controle op pointer
		if(!isset($_GET['pointer']) || !is_numeric($_GET['pointer'])){
			write_log("Fout: geen pointer opgegeven!","error");
			exit;
		}	
	
	// Parameters opvragen		
		$session_hash = $_GET['session_hash']; 
		$lerarenid	  = $_GET['lerarenid'];
		
		$datumvan	  = $_GET['datumvan'];
		$datumtot	  = $_GET['datumtot'];
		
		$pointer	  = $_GET['pointer'];
	
	// URL voor verificatie opbouwen			
		$verify_url 	  = $toolbox_url.'/public/validate_uniflow_import.php?session_hash='.$session_hash.'&key='.$uniflow_key;
	
	// Returnwaarde van verificatie
		$return = file_get_contents($verify_url);
		$return = json_decode($return);
	
	// Data ontvangen?
		if(!is_object($return)){
			write_log("Foutieve return waarde","error");
			exit;
		}
	
	// Lerarenid in data?
		if(!property_exists($return, 'lerarenid')){
			write_log("Foutieve return waarde: geen lerarenid","error");
			exit;
		}
	
	// Juiste lerarenid
		if($return->lerarenid != $lerarenid){
			write_log("Foutieve lerarenid","error");
			exit;
		}
	
	// Gegevens opvragen
		$link_uniflow_edu = mssql_conn_uniflow_edu($mssql_host_uniflow_edu, $mssql_user_uniflow_edu, $mssql_pass_uniflow_edu, $mssql_data_uniflow_edu);
		
		$query  = "select PersonRef, PersonName, PersonIndividualCosts
						from EduFlatUsage_V
						where CostCenterRef = '__private__' and PersonRole = 1 and JobTimestamp > '$datumvan' and JobTimestamp < '$datumtot' and PersonRef = '$pointer'";
		
		$result = sqlsrv_query($link_uniflow_edu, $query);
		
		$arr_result = array();
	
		while($row = sqlsrv_fetch_array($result)){
			$PersonRef					 = $row['PersonRef'];
			$PersonName 	 			 = $row['PersonName'];
			$PersonIndividualCosts		 = $row['PersonIndividualCosts'];
			
			$row = array('personref'=>$PersonRef,'PersonName'=>$PersonName,'PersonIndividualCosts'=>$PersonIndividualCosts);
			
			$arr_result[] = $row;
		}
		
		echo json_encode($arr_result);





?>